jQuery(document).ready(function($) {
    'use strict';

    // Test connection button
    $('#cf7-klaviyo-test-connection').on('click', function(e) {
        e.preventDefault();

        var $button = $(this);
        var $result = $('#cf7-klaviyo-test-result');

        $button.prop('disabled', true).text('Probando...');
        $result.html('<span style="color: #999;">Conectando con Klaviyo...</span>');

        $.ajax({
            url: cf7KlaviyoAdmin.ajax_url,
            type: 'POST',
            data: {
                action: 'cf7_klaviyo_test_connection',
                nonce: cf7KlaviyoAdmin.nonce
            },
            success: function(response) {
                if (response.success) {
                    $result.html('<span style="color: green;">✓ ' + response.data.message + '</span>');
                } else {
                    var errorMsg = response.data.message;
                    // Si el mensaje es un objeto, intentar parsearlo
                    if (typeof errorMsg === 'object') {
                        errorMsg = JSON.stringify(errorMsg);
                    }
                    $result.html('<span style="color: red;">✗ Error: ' + errorMsg + '</span>');
                }
            },
            error: function(xhr, status, error) {
                var errorMsg = error;
                try {
                    var responseText = JSON.parse(xhr.responseText);
                    if (responseText.data && responseText.data.message) {
                        errorMsg = responseText.data.message;
                    }
                } catch(e) {
                    // Mantener el mensaje de error original
                }
                $result.html('<span style="color: red;">✗ Error de conexión: ' + errorMsg + '</span>');
            },
            complete: function() {
                $button.prop('disabled', false).text('Probar Conexión');
            }
        });
    });
});
