jQuery(document).ready(function($) {
    'use strict';

    // Toggle Klaviyo settings visibility
    $('#cf7-klaviyo-enabled').on('change', function() {
        if ($(this).is(':checked')) {
            $('#cf7-klaviyo-settings-container').slideDown();
        } else {
            $('#cf7-klaviyo-settings-container').slideUp();
        }
    });

    // Load Klaviyo lists
    $('#cf7-klaviyo-load-lists').on('click', function(e) {
        e.preventDefault();

        var $button = $(this);
        var $spinner = $button.next('.spinner');
        var $selectContainer = $('#cf7-klaviyo-list-select-container');
        var $select = $('#cf7-klaviyo-list-id');

        $button.prop('disabled', true);
        $spinner.addClass('is-active');

        $.ajax({
            url: cf7KlaviyoForm.ajax_url,
            type: 'POST',
            data: {
                action: 'cf7_klaviyo_get_lists',
                nonce: cf7KlaviyoForm.nonce
            },
            success: function(response) {
                if (response.success && response.data.lists) {
                    var currentValue = $select.val();

                    // Clear and rebuild options
                    $select.empty();
                    $select.append('<option value="">-- Selecciona una lista --</option>');

                    $.each(response.data.lists, function(index, list) {
                        var selected = (currentValue === list.id) ? 'selected' : '';
                        $select.append(
                            '<option value="' + list.id + '" ' + selected + '>' +
                            list.name +
                            '</option>'
                        );
                    });

                    $selectContainer.slideDown();

                    // Show success message
                    var message = $('<div class="notice notice-success inline" style="margin: 10px 0;"><p>Listas cargadas correctamente</p></div>');
                    $selectContainer.after(message);
                    setTimeout(function() {
                        message.fadeOut(function() { $(this).remove(); });
                    }, 3000);

                } else {
                    alert('Error al cargar las listas: ' + (response.data.message || 'Error desconocido'));
                }
            },
            error: function(xhr, status, error) {
                alert('Error de conexión: ' + error);
            },
            complete: function() {
                $button.prop('disabled', false);
                $spinner.removeClass('is-active');
            }
        });
    });

    // Store list name when list is selected
    $('#cf7-klaviyo-list-id').on('change', function() {
        var selectedText = $(this).find('option:selected').text();

        // Remove or update hidden input for list name
        $('input[name="cf7_klaviyo[list_name]"]').remove();

        if ($(this).val()) {
            $(this).after(
                '<input type="hidden" name="cf7_klaviyo[list_name]" value="' +
                selectedText + '">'
            );
        }
    });

    // Toggle custom field name input based on Klaviyo field selection
    $('.klaviyo-field-select').on('change', function() {
        var $customInput = $(this).closest('tr').find('.custom-field-name');

        if ($(this).val() === 'custom') {
            $customInput.prop('disabled', false).focus();
        } else {
            $customInput.prop('disabled', true).val('');
        }
    });

    // Initialize custom field inputs on page load
    $('.klaviyo-field-select').each(function() {
        if ($(this).val() !== 'custom') {
            $(this).closest('tr').find('.custom-field-name').prop('disabled', true);
        }
    });

    // Warning if no email field is mapped
    $('form').on('submit', function(e) {
        if (!$('#cf7-klaviyo-enabled').is(':checked')) {
            return true;
        }

        var hasEmail = false;
        $('.klaviyo-field-select').each(function() {
            if ($(this).val() === 'email') {
                hasEmail = true;
                return false;
            }
        });

        if (!hasEmail) {
            var confirmSubmit = confirm(
                'Advertencia: No has mapeado ningún campo como "Email". ' +
                'El campo Email es obligatorio para Klaviyo.\n\n' +
                '¿Deseas continuar de todos modos?'
            );

            if (!confirmSubmit) {
                e.preventDefault();
                return false;
            }
        }

        if (!$('#cf7-klaviyo-list-id').val()) {
            alert('Por favor selecciona una lista de Klaviyo antes de guardar.');
            e.preventDefault();
            return false;
        }
    });
});
