jQuery(document).ready(function($) {
    'use strict';

    // Helper function para mostrar resultados
    function showResult($container, data, isError) {
        $container.removeClass('success error loading');

        if (isError) {
            $container.addClass('error');
        } else {
            $container.addClass('success');
        }

        var html = '';

        // Título
        if (isError) {
            html += '<h3 style="color: #dc3545; margin-top: 0;">✗ Error</h3>';
        } else {
            html += '<h3 style="color: #28a745; margin-top: 0;">✓ Éxito</h3>';
        }

        // Status code
        if (data.status_code) {
            html += '<p><strong>Status Code:</strong> <code>' + data.status_code + '</code></p>';
        }

        // Success
        if (data.success !== undefined) {
            html += '<p><strong>Success:</strong> <code>' + (data.success ? 'true' : 'false') + '</code></p>';
        }

        // Error message
        if (data.error) {
            html += '<div style="margin: 10px 0;">';
            html += '<strong>Error:</strong><br>';
            if (typeof data.error === 'string') {
                html += '<p style="color: #721c24;">' + data.error + '</p>';
            } else {
                html += '<pre>' + JSON.stringify(data.error, null, 2) + '</pre>';
            }
            html += '</div>';
        }

        // Data
        if (data.data) {
            html += '<div style="margin: 10px 0;">';
            html += '<strong>Datos Recibidos:</strong><br>';
            html += '<pre>' + JSON.stringify(data.data, null, 2) + '</pre>';
            html += '</div>';
        }

        // Raw response
        if (data.raw_response) {
            html += '<details style="margin: 10px 0;">';
            html += '<summary><strong>Respuesta Raw (JSON)</strong></summary>';
            html += '<pre>' + data.raw_response + '</pre>';
            html += '</details>';
        }

        // Full response
        html += '<details style="margin: 10px 0;">';
        html += '<summary><strong>Respuesta Completa (Debug)</strong></summary>';
        html += '<pre>' + JSON.stringify(data, null, 2) + '</pre>';
        html += '</details>';

        $container.html(html).show();
    }

    function showLoading($container, message) {
        $container.removeClass('success error').addClass('loading');
        $container.html('<p>⏳ ' + (message || 'Ejecutando petición...') + '</p>').show();
    }

    // Test 1: GET /lists/
    $('[data-test="get_lists"]').on('click', function() {
        var $btn = $(this);
        var $result = $('#test-get-lists');

        $btn.prop('disabled', true).text('Ejecutando...');
        showLoading($result, 'Obteniendo listas de Klaviyo...');

        $.ajax({
            url: cf7KlaviyoTest.ajax_url,
            type: 'POST',
            data: {
                action: 'cf7_klaviyo_test_raw_request',
                nonce: cf7KlaviyoTest.nonce,
                method: 'GET',
                endpoint: 'lists/'
            },
            success: function(response) {
                showResult($result, response, !response.success);

                // Mostrar resumen de listas si hay
                if (response.success && response.data && response.data.data) {
                    var listCount = response.data.data.length;
                    var summary = '<div style="background: #fff; padding: 10px; margin: 10px 0; border-radius: 3px;">';
                    summary += '<p><strong>Total de listas encontradas:</strong> ' + listCount + '</p>';

                    if (listCount > 0) {
                        summary += '<ul>';
                        response.data.data.forEach(function(list) {
                            summary += '<li><strong>' + list.attributes.name + '</strong> (ID: ' + list.id + ')</li>';
                        });
                        summary += '</ul>';
                    }
                    summary += '</div>';

                    $result.prepend(summary);
                }
            },
            error: function(xhr, status, error) {
                showResult($result, {
                    success: false,
                    error: 'Error AJAX: ' + error,
                    status_code: xhr.status
                }, true);
            },
            complete: function() {
                $btn.prop('disabled', false).text('Ejecutar Test');
            }
        });
    });

    // Test 2: GET /accounts/
    $('[data-test="get_account"]').on('click', function() {
        var $btn = $(this);
        var $result = $('#test-get-account');

        $btn.prop('disabled', true).text('Ejecutando...');
        showLoading($result, 'Obteniendo información de cuenta...');

        $.ajax({
            url: cf7KlaviyoTest.ajax_url,
            type: 'POST',
            data: {
                action: 'cf7_klaviyo_test_get_account',
                nonce: cf7KlaviyoTest.nonce
            },
            success: function(response) {
                showResult($result, response, !response.success);

                // Mostrar info de cuenta si hay
                if (response.success && response.data && response.data.data) {
                    var account = response.data.data[0];
                    if (account) {
                        var info = '<div style="background: #fff; padding: 10px; margin: 10px 0; border-radius: 3px;">';
                        info += '<h4>Información de la Cuenta:</h4>';
                        info += '<p><strong>ID:</strong> ' + account.id + '</p>';
                        if (account.attributes) {
                            if (account.attributes.company_name) {
                                info += '<p><strong>Empresa:</strong> ' + account.attributes.company_name + '</p>';
                            }
                            if (account.attributes.contact_information && account.attributes.contact_information.default_sender_email) {
                                info += '<p><strong>Email:</strong> ' + account.attributes.contact_information.default_sender_email + '</p>';
                            }
                        }
                        info += '</div>';

                        $result.prepend(info);
                    }
                }
            },
            error: function(xhr, status, error) {
                showResult($result, {
                    success: false,
                    error: 'Error AJAX: ' + error,
                    status_code: xhr.status
                }, true);
            },
            complete: function() {
                $btn.prop('disabled', false).text('Ejecutar Test');
            }
        });
    });

    // Test 3: POST /profiles/ (Crear perfil)
    $('[data-test="create_profile"]').on('click', function() {
        var $btn = $(this);
        var $result = $('#test-create-profile');

        var email = $('#test-email').val();
        var firstName = $('#test-first-name').val();
        var lastName = $('#test-last-name').val();

        if (!email) {
            alert('Por favor introduce un email');
            return;
        }

        $btn.prop('disabled', true).text('Creando...');
        showLoading($result, 'Creando perfil en Klaviyo...');

        $.ajax({
            url: cf7KlaviyoTest.ajax_url,
            type: 'POST',
            data: {
                action: 'cf7_klaviyo_test_create_profile',
                nonce: cf7KlaviyoTest.nonce,
                email: email,
                first_name: firstName,
                last_name: lastName
            },
            success: function(response) {
                showResult($result, response, !response.success);

                if (response.success && response.profile_id) {
                    var info = '<div style="background: #d4edda; padding: 10px; margin: 10px 0; border-radius: 3px;">';
                    info += '<p style="color: #155724;"><strong>✓ Perfil creado exitosamente!</strong></p>';
                    info += '<p><strong>Profile ID:</strong> <code>' + response.profile_id + '</code></p>';
                    info += '</div>';

                    $result.prepend(info);
                }
            },
            error: function(xhr, status, error) {
                showResult($result, {
                    success: false,
                    error: 'Error AJAX: ' + error,
                    status_code: xhr.status
                }, true);
            },
            complete: function() {
                $btn.prop('disabled', false).text('Ejecutar Test');
            }
        });
    });

    // Test 4: Raw Request
    $('[data-test="raw_request"]').on('click', function() {
        var $btn = $(this);
        var $result = $('#test-raw-request');

        var method = $('#raw-method').val();
        var endpoint = $('#raw-endpoint').val();
        var body = $('#raw-body').val();

        if (!endpoint) {
            alert('Por favor introduce un endpoint');
            return;
        }

        $btn.prop('disabled', true).text('Ejecutando...');
        showLoading($result, 'Ejecutando ' + method + ' ' + endpoint + '...');

        $.ajax({
            url: cf7KlaviyoTest.ajax_url,
            type: 'POST',
            data: {
                action: 'cf7_klaviyo_test_raw_request',
                nonce: cf7KlaviyoTest.nonce,
                method: method,
                endpoint: endpoint,
                body: body
            },
            success: function(response) {
                showResult($result, response, !response.success);
            },
            error: function(xhr, status, error) {
                showResult($result, {
                    success: false,
                    error: 'Error AJAX: ' + error,
                    status_code: xhr.status
                }, true);
            },
            complete: function() {
                $btn.prop('disabled', false).text('Ejecutar Petición');
            }
        });
    });

    // Auto-clear body cuando se cambia a GET
    $('#raw-method').on('change', function() {
        if ($(this).val() === 'GET') {
            $('#raw-body').val('').prop('disabled', true);
        } else {
            $('#raw-body').prop('disabled', false);
        }
    });
});
