<?php
/**
 * Plugin Name: Contact Form 7 - Klaviyo Integration
 * Plugin URI: https://webdesignerk.com
 * Description: Integra Contact Form 7 con Klaviyo API para enviar suscriptores a listas
 * Version: 1.0.0
 * Author: Konstantin WDK
 * Author URI: https://webdesignerk.com
 * License: GPL2
 * Text Domain: cf7-klaviyo
 * Domain Path: /languages
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
define('CF7_KLAVIYO_VERSION', '1.0.0');
define('CF7_KLAVIYO_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('CF7_KLAVIYO_PLUGIN_URL', plugin_dir_url(__FILE__));

// Main plugin class
class CF7_Klaviyo_Integration {

    private static $instance = null;

    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        $this->load_dependencies();
        $this->init_hooks();
    }

    private function load_dependencies() {
        require_once CF7_KLAVIYO_PLUGIN_DIR . 'includes/class-cf7-klaviyo-settings.php';
        require_once CF7_KLAVIYO_PLUGIN_DIR . 'includes/class-cf7-klaviyo-api.php';
        require_once CF7_KLAVIYO_PLUGIN_DIR . 'includes/class-cf7-klaviyo-form-settings.php';
        require_once CF7_KLAVIYO_PLUGIN_DIR . 'includes/class-cf7-klaviyo-submission.php';
        require_once CF7_KLAVIYO_PLUGIN_DIR . 'includes/class-cf7-klaviyo-test-panel.php';
    }

    private function init_hooks() {
        add_action('plugins_loaded', array($this, 'check_dependencies'));
        add_action('admin_notices', array($this, 'admin_notices'));

        if ($this->check_dependencies()) {
            CF7_Klaviyo_Settings::get_instance();
            CF7_Klaviyo_Form_Settings::get_instance();
            CF7_Klaviyo_Submission::get_instance();
            CF7_Klaviyo_Test_Panel::get_instance();
        }
    }

    public function check_dependencies() {
        // Check if Contact Form 7 is active
        if (!class_exists('WPCF7')) {
            add_action('admin_notices', array($this, 'cf7_missing_notice'));
            return false;
        }
        return true;
    }

    public function cf7_missing_notice() {
        ?>
        <div class="notice notice-error">
            <p><?php _e('Contact Form 7 - Klaviyo Integration requiere que Contact Form 7 esté instalado y activado.', 'cf7-klaviyo'); ?></p>
        </div>
        <?php
    }

    public function admin_notices() {
        // Placeholder for admin notices
    }
}

// Activation hook
function cf7_klaviyo_activate() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'cf7_klaviyo_submissions';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE IF NOT EXISTS $table_name (
        id bigint(20) NOT NULL AUTO_INCREMENT,
        form_id bigint(20) NOT NULL,
        email varchar(255) NOT NULL,
        profile_data text,
        klaviyo_response text,
        status varchar(50) NOT NULL,
        created_at datetime NOT NULL,
        PRIMARY KEY  (id),
        KEY form_id (form_id),
        KEY email (email),
        KEY created_at (created_at)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);

    // Save plugin version
    update_option('cf7_klaviyo_version', CF7_KLAVIYO_VERSION);
}

register_activation_hook(__FILE__, 'cf7_klaviyo_activate');

// Initialize the plugin
function cf7_klaviyo_init() {
    return CF7_Klaviyo_Integration::get_instance();
}

// Start the plugin
add_action('plugins_loaded', 'cf7_klaviyo_init');
